//
//  OPCustomFieldGroup.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 12-04-09.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "OPItemField.h"

@interface OPFieldSection : NSObject

@property (nonatomic, copy) NSString *name;
@property (nonatomic, copy) NSString *title;
@property (nonatomic, readonly) NSArray *fields;
@property (nonatomic, readonly) NSArray *nonEmptyFields;

@property (nonatomic, readonly, getter = isGuarded) BOOL guarded;

+ (NSString *)uniqueSectionName;

- (BOOL)isEmpty;

- (NSInteger)numberOfFields;
- (id)fieldWithIdentifier:(NSString *)identifier;
- (id)fieldWithValue:(id)value;
- (id)fieldEqualToField:(OPItemField *)field;
- (OPItemField *)findNonEmptyConcealedField;
- (OPItemField *)fieldAtIndex:(NSInteger)index;
- (NSInteger)indexOfField:(OPItemField *)field;
- (void)insertField:(OPItemField *)field atIndex:(NSInteger)index;
- (void)addField:(OPItemField *)field;
- (void)removeField:(OPItemField *)field;
- (void)removeFieldAtIndex:(NSInteger)index;
- (void)moveField:(OPItemField *)field toIndex:(NSInteger)toIndex;
- (void)addFieldsFromSection:(OPFieldSection *)section;
- (BOOL)hasConflictForField:(OPItemField *)field;
- (void)mergeField:(OPItemField *)field;
- (NSArray *)fieldsWithIdentifierPrefix:(NSString *)prefix;

- (NSDictionary *)dictionaryRepresentation;
- (void)loadDictionary:(NSDictionary *)dictionary;

- (BOOL)isEqualToFieldSection:(OPFieldSection *)other;

- (NSArray *)allValuesForSearch;
- (NSArray *)allPasswordsForSearch;
- (NSArray *)allFieldTitlesForSearch;

@end
